/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator;

import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class SiteConnectionWorkbenchAdapter
implements IWorkbenchAdapter,
IDeferredWorkbenchAdapter {
    private static SiteConnectionWorkbenchAdapter instance;
    private static final Object[] EMPTY;
    private static final ImageDescriptor IMAGE_DESCRIPTOR;
    private static final ImageDescriptor ERROR_IMAGE_DESCRIPTOR;

    static {
        EMPTY = new Object[0];
        IMAGE_DESCRIPTOR = SyncingUIPlugin.getImageDescriptor("icons/full/obj16/ftp.png");
        ERROR_IMAGE_DESCRIPTOR = SyncingUIPlugin.getImageDescriptor("icons/full/obj16/error.png");
    }

    private SiteConnectionWorkbenchAdapter() {
    }

    static synchronized SiteConnectionWorkbenchAdapter getInstance() {
        if (instance == null) {
            instance = new SiteConnectionWorkbenchAdapter();
        }
        return instance;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof ISiteConnection) {
            ISiteConnection siteConnection = (ISiteConnection)object;
            if (siteConnection.getSource() == null || siteConnection.getDestination() == null) {
                return ERROR_IMAGE_DESCRIPTOR;
            }
            return IMAGE_DESCRIPTOR;
        }
        if (object instanceof ProjectSiteConnection) {
            object = ((ProjectSiteConnection)((Object)object)).getSiteConnection().getDestination();
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getImageDescriptor(object);
            }
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof ISiteConnection) {
            return ((ISiteConnection)object).getName();
        }
        if (object instanceof ProjectSiteConnection) {
            object = ((ProjectSiteConnection)((Object)object)).getSiteConnection().getDestination();
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(object);
            }
        }
        return String.valueOf(object);
    }

    public Object[] getChildren(Object object) {
        return EMPTY;
    }

    public Object getParent(Object o) {
        return null;
    }

    public ISchedulingRule getRule(Object object) {
        if (object instanceof IAdaptable) {
            return (ISchedulingRule)((IAdaptable)object).getAdapter(ISchedulingRule.class);
        }
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (object instanceof ProjectSiteConnection) {
            object = ((ProjectSiteConnection)((Object)object)).getSiteConnection().getDestination();
            IDeferredWorkbenchAdapter deferredWorkbenchAdapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IDeferredWorkbenchAdapter.class);
            if (deferredWorkbenchAdapter != null) {
                deferredWorkbenchAdapter.fetchDeferredChildren(object, collector, monitor);
            }
        }
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IWorkbenchAdapter.class == adapterType || IDeferredWorkbenchAdapter.class == adapterType) {
                return SiteConnectionWorkbenchAdapter.getInstance();
            }
            if (IFileStore.class == adapterType && adaptableObject instanceof ProjectSiteConnection) {
                return ((ProjectSiteConnection)((Object)adaptableObject)).getAdapter(adapterType);
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{IWorkbenchAdapter.class, IDeferredWorkbenchAdapter.class};
        }
    }
}

